#!/usr/bin/perl -T

# Version 6.0.1
#
# This script attempts to add a printer filter called pdf to the cups system, restart the
# cups daemon so it recognizes that filter, then add a queue based on that filter.
# The end result should be an Adobe PDF printer appearing in the Print Center Printer List,
# with Kind of Adobe PDF 3015.102.
#
# the procedure used is this (psuedo-code):
#
# 1. Create the spool directory that will be used by the PDFMaker module when it prints to Adobe PDF
# 2. Make sure it has proper ownership and permissions.
# 3. Look through the running process list for the cups daemon. Give is a restart command if found (kill -HUP {pid}).
# 4. If it wasn't found, it's not running. We need it running to do all this, so try to restart it.
#      Terminate with the error message 
#        "The cups daemon was not running, and did not restart after 2 seconds, aborting."
#      if it doesn't restart
# 5. Once it's either been restarted, or is running from a fresh start, we try to add the queue.
# 6. We retry the queue add 10 times. We check cupsd after each try, and if it's not running, we start it.
# 7. We finally check to see if we've been successful, and print an error message if not.
#
# Change the 0 in this statement to 1 to get debug printouts while executing. Change it back to 0 when done.
#    
$debug = 0;

# added to run in secure environment
$ENV{'PATH'} = '/bin:/usr/bin';  #or whatever you need
$ENV{'SHELL'} = '/bin/sh' if $ENV{'SHELL'} ne '';
$ENV{'IFS'} = '' if $ENV{'IFS'} ne '';
#end of added code.

open(CONSOLE, ">>/dev/console") or die "$!";
select CONSOLE;

`/bin/chmod go-w /usr/libexec/cups/backend/pdf700`;

`/bin/mkdir /var/spool/PDFMaker` if (!(-e "/var/spool/PDFMaker"));
`/usr/sbin/chown nobody /var/spool/PDFMaker`;
`/usr/bin/chgrp nobody /var/spool/PDFMaker`;
`/bin/chmod 777 /var/spool/PDFMaker`;



$foundit = 0;
foreach (`ps -axwwww`) 
{
	chop;			# remove trailing newline
	s/^\s+//;		# strip leading spaces
	s/\s+$//;		# strip trailing spaces
	($npid, $tty, $stat, $time, @cmd) = split(/\s+/, $_);
	$temp = ($npid =~ /\w*\d+\w*/);
#	$pid = $1;                                   # Untaint pid
	undef $err;
	if (($cmd = join(' ', @cmd)) =~ m;/usr/sbin/cupsd;) 
	{
		if( $debug eq 1) {print "The string is $_\n"};
		/(\d+)/;
		$pid = $1;
		if( $debug eq 1) {print "Substring 1 is $1\n"};
		if( $debug eq 1) {print "About to kill -HUP on $pid\n"};
		system "/bin/kill", "-HUP", "$pid";      # found the cupsd process, restart it
		if ($debug eq 1) {print "Did the kill -HUP on $pid\n"};
		$foundit = 1;
		$cpid = $pid;                            # save pid for next step
	}
}


if ($foundit == 0) 
{
	`/usr/sbin/cupsd`;                           # issue restart command if process no longer running
	`/bin/sleep 2`;                              # wait for it to start up
	# see if cupsd is running now; if not, error out?
	$foundit = 0;
	foreach (`ps -axwwww`) 
	{
		chop;			# remove trailing newline
		s/^\s+//;		# strip leading spaces
		s/\s+$//;		# strip trailing spaces
		($npid, $tty, $stat, $time, @cmd) = split(/\s+/, $_);
	    $temp = ($npid =~ /\w*\d+\w*/);
	    $pid = $1;                                   # Untaint pid
		undef $err;
		if (($cmd = join(' ', @cmd)) =~ m;/usr/sbin/cupsd;) 
		{
			$foundit = 1;
			if ($cpid != $pid) 
			{
				print "Change in cupsd process ID from $cpid to $pid" if $debug == 1;
				$cpid = $pid;
			}
		}
	}
}

if ($foundit == 0) {
	die ("The cups daemon was not running, and would not restart after 2 seconds, aborting.\n");
}



#
# have done kill -HUP on cupsd at this point (or started it up), wait till it returns
#
$foundit = 1;
$pscommand = "Echo \"No cupsd running!\"";
if ($cpid =~ /(\d+)$/) {
    $pscommand = "ps -axwwp" . $1;            # remove taint from $cpid
}

for($i = 1; $i <= 10; $i++) 
{
	`/bin/sleep 1`;               # wait one second
	$_ = `$pscommand`;            # look for just the cupsd pid, since we know what it is
	chop;			              # remove trailing newline
	s/^\s+//;		              # strip leading spaces
	s/\s+$//;		              # strip trailing spaces
	($pid, $tty, $stat, $time, @cmd) = split(/\s+/, $_);   # parse line into components
	if (($cmd = join(' ', @cmd)) =~ m;/usr/sbin/cupsd;) 
	{
	    print "cupsd came back after $i iterations.\n" if ($debug == 1);
	    $foundit = 1;
	    last;
	}
}

if($foundit == 0) 
{
							# cupsd wasn't found in process list, start it up with default parameters.
	`/usr/sbin/cupsd`;                           # issue restart command if process no longer running
	`/bin/sleep 2`;                              # wait for it to start up

	foreach (`ps -axwwww`) 
	{
		chop;			# remove trailing newline
		s/^\s+//;		# strip leading spaces
		s/\s+$//;		# strip trailing spaces
		($pid, $tty, $stat, $time, @cmd) = split(/\s+/, $_);
		if (($cmd = join(' ', @cmd)) =~ m;/usr/sbin/cupsd;) 
		{
			$foundit = 1;
			if ($cpid != $pid) 
			{
				print "Change in cupsd process ID from $cpid to $pid" if $debug == 1;
				$cpid = $pid;
			}
		}
	}
}

#  OK, cupsd has been re-initialized or restarted, add the queue.

$foundit = 0;
for($i = 1; $i <= 10; $i++) 
{
	`/bin/sleep $i`;
	`/usr/sbin/lpadmin -p 'AdobePDF7' -v pdf700://distiller/ -P /Library/Printers/PPDs/Contents/Resources/en.lproj/ADPDF7.PPD -E -D 'Adobe PDF 7.0'`;
	$err = $?;
	
	if ($err == 0) 
	{
	    print "Successfully added AdobePDF printer on $i iteration.\n" if ($debug == 1);
	    $foundit = 1;
	    last;
	}
	
	# see if cupsd is even running; restart it if not.
	$foundit = 0;
	foreach (`ps -axwwww`)
	{
		chop;			# remove trailing newline
		s/^\s+//;		# strip leading spaces
		s/\s+$//;		# strip trailing spaces
		($pid, $tty, $stat, $time, @cmd) = split(/\s+/, $_);
		undef $err;
		if (($cmd = join(' ', @cmd)) =~ m;/usr/sbin/cupsd;) 
		{
			$foundit = 1;
			if ($cpid != $pid) 
			{
				print "Change in cupsd process ID from $cpid to $pid" if $debug == 1;
				$cpid = $pid;
			}
		}
	}
	# Have finished looking for the cupsd process, check result
	
	if ($foundit == 0) 
	{
		`/usr/sbin/cupsd`;                           # issue restart command if process no longer running
		`/bin/sleep 2`;                              # wait for it to start up
		
		$foundit = 0;							# see if cupsd is running now; if not, error out
		foreach (`ps -axwwww`) 
		{
			chop;			# remove trailing newline
			s/^\s+//;		# strip leading spaces
			s/\s+$//;		# strip trailing spaces
			($pid, $tty, $stat, $time, @cmd) = split(/\s+/, $_);
			undef $err;
			if (($cmd = join(' ', @cmd)) =~ m;/usr/sbin/cupsd;) 
			{
				$foundit = 1;
				if ($cpid != $pid) 
				{
					print "Change in cupsd process ID from $cpid to $pid" if $debug == 1;
					$cpid = $pid;
				}
			}
		}
		if ($foundit == 0) 
		{
			die ("The cups daemon did not restart after 2 seconds, aborting.\n");
		}
	}
}
print "Couldn't add the AdobePDF printer.\n" if ($foundit == 0);
